%------------------------------------------------------------------------------
% File     : NUM770^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 67e
% Version  : Especial.
% English  : eq v (mf x y)

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz67e [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.00 v5.3.0, 0.25 v5.2.0, 0.00 v3.7.0
% Syntax   : Number of formulae    :   13 (   0 unit;   8 type;   0 defn)
%            Number of atoms       :   36 (   0 equality;  14 variable)
%            Maximal formula depth :   11 (   4 average)
%            Number of connectives :   31 (   0   ~;   0   |;   0   &;  28   @)
%                                         (   0 <=>;   3  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    8 (   8   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   10 (   8   :;   0   =)
%            Number of variables   :    6 (   0 sgn;   6   !;   0   ?;   0   ^)
%                                         (   6   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(frac_type,type,(
    frac: $tType )).

thf(x,type,(
    x: frac )).

thf(y,type,(
    y: frac )).

thf(v,type,(
    v: frac )).

thf(moref,type,(
    moref: frac > frac > $o )).

thf(m,axiom,
    ( moref @ x @ y )).

thf(eq,type,(
    eq: frac > frac > $o )).

thf(pf,type,(
    pf: frac > frac > frac )).

thf(e,axiom,
    ( eq @ ( pf @ y @ v ) @ x )).

thf(mf,type,(
    mf: frac > frac > frac )).

thf(satz67b,axiom,(
    ! [Xx: frac,Xy: frac,Xv: frac,Xw: frac] :
      ( ( eq @ ( pf @ Xy @ Xv ) @ Xx )
     => ( ( eq @ ( pf @ Xy @ Xw ) @ Xx )
       => ( eq @ Xv @ Xw ) ) ) )).

thf(satz67c,axiom,(
    ! [Xx: frac,Xy: frac] :
      ( ( moref @ Xx @ Xy )
     => ( eq @ ( pf @ Xy @ ( mf @ Xx @ Xy ) ) @ Xx ) ) )).

thf(satz67e,conjecture,
    ( eq @ v @ ( mf @ x @ y ) )).

%------------------------------------------------------------------------------
